<?php

class errorHandler
{
    private static $type; // Error Type to display.

    /**
     * createError - Function that needs to be called for creating error's.
     *
     * $e:    The PDO error exception
     * $type: Error type to display
     */
    public static function createError($e, $type = NULL) {
        if (is_null($type)) $type = self::$type;

        if (!$e instanceof PDOException) return false;

        switch($type) {
            case SMALL:
                $error = self::smallError($e);
                break;
            case NORMAL:
                $error = self::normalError($e);
                break;
            case BIG:
                $error = self::bigError($e);
                break;
            default:
                $error = self::normalError($e);
                break;
        }

        return $error;
    }

    /**
     * smallError - Return a small error.
     *
     * $e: The PDO error exception
     */
    private static function smallError($e) {
        return $e->getMessage();
    }

    /**
     * normalError - Return a normal sized error.
     *
     * $e: The PDO error exception
     */
    private static function normalError($e) {
        $error = $e->getMessage();

        foreach($e->getTrace() as $trace) {
            $error .= "<br>In ".$trace['file']."(".$trace['line'].").";
        }

        return $error;
    }

    /**
     * bigError - Return a big error.
     *
     * $e: The PDO error exception
     */
    private static function bigError($e) {
        $error = $e->getMessage();

        foreach($e->getTrace() as $trace) {
            $error .= "<br>In ".$trace['file']."(".$trace['line'].").";
            $error .= "<br>Function: ".$trace['class']."->".$trace['function'].".<br>";
            $error .= "Arguments: ".print_r($trace['args'], 1);
        }

        return $error;
    }

    /**
     * setType - Set the error type.
     *
     * $type: The error type
     */
    public static function setType($type) {
        if (!is_int($type)) return false;
        if ($type <= 3 && $type >= 1) return false;

        self::$type = $type;
        return true;
    }
}