<?php
include("_config.php");
session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);



// Config Gedeelte
$cfg['url'] = "site";// Site waarnaar je terug gaat als je een bericht hebt achtergelaten
$cfg['naam'] = "naam";                // Webmaster naam
$cfg['email'] = "email";        // Webmaster E-mail
$cfg['spam'] = 0;                        // Anti Spam Tijd in Minuten ( Voer "0" om de Spam Beveiliging uit te zetten )
$cfg['text'] = TRUE;                    // Bij Fout Text Rood maken ( TRUE voor aan, FALSE voor uit )
$cfg['input'] = TRUE;                    // Bij Fout Border om Vakje Rood maken ( TRUE voor aan, FALSE voor uit )
$cfg['HTML'] = TRUE;                    // Een HTML email ( TRUE voor aan, FALSE voor uit )
$cfg['CAPTCHA'] = TRUE;                    // CAPTCHA ( TRUE voor aan, FALSE voor uit )


// Hieronder niks meer veranderen
// E-mail Checker / Validator
function checkmail($email)
{
    if(preg_match("^[0-9a-z]([-_.]?[0-9a-z])*@[0-9a-z]([-.]?[0-9a-z])*\\.[a-z]{2,4}$", $email))
    {
        return TRUE;
    }
    return FALSE;
}

$formulier = TRUE;

if(!isset($_COOKIE['formulier']))
{
    if(isset($_POST['wis']) && ($_SERVER['REQUEST_METHOD'] == "POST"))
    {
        foreach($_POST as $key => $value)
        {
            unset($value);
        }
        header("Location: ".$_SERVER['PHP_SELF']."");
    }
        
    if(isset($_POST['verzenden']) && ($_SERVER['REQUEST_METHOD'] == "POST"))
    {
        $aFout = array();
        
        $naam = trim($_POST['naam']);
        $email = trim($_POST['email']);
        $onderwerp = trim($_POST['onderwerp']);
        $bericht = trim($_POST['bericht']);
        
        if($cfg['CAPTCHA'])
        {
            $code = $_POST['code'];
        }
                
        if(empty($naam) || (strlen($naam) < 3) || ( preg_match("[<>]", $naam) ) )
        {
            $aFout[] = "Er is geen naam ingevuld.";
            unset($naam);
            $fout['text']['naam'] = TRUE;
            $fout['input']['naam'] = TRUE;
        }
        if(empty($email))
        {
            $aFout[] = "Er is geen e-mail adres ingevuld.";
            unset($email);
            $fout['text']['email'] = TRUE;
            $fout['input']['email'] = TRUE;
        }
        //elseif(checkmail($email) == 0)
        // Wanneer je PHP 5.2 > gebruikt
        elseif(!filter_var($email, FILTER_VALIDATE_EMAIL)) 
        {
            $aFout[] = "Er is geen correct e-mail adres ingevuld.";
            unset($email);
            $fout['text']['email'] = TRUE;
            $fout['input']['email'] = TRUE;
        }
        if(empty($onderwerp))
        {
            $aFout[] = "Er is geen onderwerp ingevuld.";
            unset($onderwerp);
            $fout['text']['onderwerp'] = TRUE;
            $fout['input']['onderwerp'] = TRUE;
        }
        if(empty($bericht))
        {
            $aFout[] = "Er is geen bericht ingevuld.";
            unset($bericht);
            $fout['text']['bericht'] = TRUE;
            $fout['input']['bericht'] = TRUE;
        }
        if($cfg['CAPTCHA'])
        {
            if(strtoupper($code) != $_SESSION['captcha_code'])
            {
                $aFout[] = "Er is geen correcte code ingevuld.";
                $fout['text']['code'] = TRUE;
                $fout['input']['code'] = TRUE;
            }
        }
        if(!$cfg['text'])
        {
            unset($fout['text']);
        }
        if(!$cfg['input'])
        {
            unset($fout['input']);
        }
        if(!empty( $aFout ))
        {
            $errors = '
            <div id="errors">
            <ul>';
            foreach($aFout as $sFout)

            {
                $errors .= "    <li>".$sFout."</li>\n";
            }
            $errors .= "</ul>
            </div>";
        }
        else
        {
            $formulier = FALSE;
            
            
            if($cfg['HTML'])
            {
                // Headers
                $headers = "From: \"Contact Formulier\" <".$cfg['email'].">\r\n"; 
                $headers .= "Reply-To: \"".$naam."\" <".$email.">\n";
                $headers .= "Return-Path: Mail-Error <".$cfg['email'].">\n";
                $headers .= "MIME-Version: 1.0\n";
                $headers .= "Content-Transfer-Encoding: 8bit\n";
                $headers .= "Content-type: text/html; charset=iso-8859-1\n";
                
                
                $bericht = '
                <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
                <html>
                <head>
                </head>
            
                <body>
                <br />
                <b>Naam:</b> '.$naam.'<br />
                <b>Email:</b> <a href=\"mailto:'.$email.'\">'.$email.'</a><br />
                <br />
                <b>Bericht:</b><br />
                '.$bericht.'
                <br />
                <br />
                <br />
                --------------------------------------------------------------------------<br />
                <b>Datum:</b> '.date("d-m-Y @ H:i:s").'<br />
                <b>IP:</b> <a href=\"http://sunny.nic.com/cgi-bin/whois?domain='.$_SERVER['REMOTE_ADDR'].'\">'.$_SERVER['REMOTE_ADDR'].'</a><br />
                <b>Host:</b> '.gethostbyaddr($_SERVER['REMOTE_ADDR']).'<br />
                </body>
                </html>';
            }
            else 
            {
                $bericht_wrap = wordwrap ($bericht, 40, "\n", 1);
                // Headers
                $headers = "From: \"Contact Formulier\" <".$cfg['email'].">\n"; 
                $headers .= "MIME-Version: 1.0\n";
                $headers .= "Content-type: text/plain; charset='iso-8859-1'\n"; 
            
                // Bericht
                $message = "Naam: ".$naam."        \n";
                $message .= "E-mail: ".$email."     \n";
                $message .= "Bericht:\n".$bericht_wrap."     \n ";
                $message .= "               \n ";
                $message .= "Datum: ".date("d-m-Y H:i:s")." \n";
                $message .= "------------------------------------------------------- \n ";
                $message .= "IP: ".$_SERVER['REMOTE_ADDR']."                    \n ";
                $message .= "Host: ".gethostbyaddr($_SERVER['REMOTE_ADDR'])."                \n ";
            
            }
        
            if(mail($cfg['email'], "[Contact] ".$onderwerp, $bericht, $headers)) 
            {
                if(isset($_POST['stuurkopie']))
                {
                    $headers = "From: \"Contact Formulier\" <".$email.">\r\n"; 
                    $headers .= "Reply-To: \"".$naam."\" <".$email.">\n";
                    $headers .= "Return-Path: Mail-Error <".$email.">\n";
                    $headers .= "MIME-Version: 1.0\n";
                    $headers .= "Content-Transfer-Encoding: 8bit\n";
                    $headers .= "Content-type: text/html; charset=iso-8859-1\n";
                    
                    mail($email, "[Contact] ".$onderwerp, $bericht, $headers);
                
                }
                
                unset($naam, $email, $onderwerp, $bericht);
                setcookie("formulier", 1, time() + ( $cfg['spam'] * 60 ) );
        
                echo "
                <p>
                Uw bericht is succesvol verzonden, er word zo snel mogelijk gereageerd.<br />
                <br />
                Met vriendelijke groeten,<br />
                <b>".$cfg['naam']."</b>
                </p>
                ";    
            }
            else
            {
                echo "Er is een fout opgetreden bij het verzenden van de email";
            }
            header("refresh:3;url=".$cfg['url']."");
        }
    }
    if($formulier)
    {
    ?>
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
     "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
    
    <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <link href="style-contact.css" rel="stylesheet" type="text/css" />
        
        
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
        <meta http-equiv="Content-Language" content="nl" />
    </head>
    
    <body>
    <div id="container">   
    <?php
    if(isset($errors)) {
        echo $errors;
    }
    ?>


        <form method="post" action="<?php $_SERVER['PHP_SELF']; ?>">
        <p>
        <label <?php if(isset($fout['text']['naam'])) { echo 'class="fout"'; } ?>>Naam:</label>
        <input type="text" id="naam" name="naam" maxlength="30" <?php if(isset($fout['input']['naam'])) { echo 'class="fout"'; } ?> value="<?php if (!empty($naam)) { echo stripslashes($naam); } ?>" /><br />
        
        <label <?php if(isset($fout['text']['email'])) { echo 'class="fout"'; } ?>>Email:</label>
        <input type="text" id="email" name="email" maxlength="255" <?php if(isset($fout['input']['email'])) { echo 'class="fout"'; } ?> value="<?php if (!empty($email)) { echo stripslashes($email); } ?>" /><br />
        
        <label <?php if(isset($fout['text']['onderwerp'])) { echo 'class="fout"'; } ?>>Onderwerp:</label>
        <input type="text" id="onderwerp" name="onderwerp" maxlength="40" <?php if(isset($fout['input']['onderwerp'])) { echo 'class="fout'; } ?> value="<?php if (!empty($onderwerp)) { echo stripslashes($onderwerp); } ?>" /><br />
        
        <label <?php if(isset($fout['text']['bericht'])) { echo 'class="fout"'; } ?>>Bericht:</label>
        <textarea id="bericht" name="bericht" <?php if(isset($fout['input']['bericht'])) { echo 'class="fout"'; } ?> cols="35" rows="6"><?php if (!empty($bericht)) { echo stripslashes($bericht); } ?></textarea><br />

        <?php
        if($cfg['CAPTCHA'])
        {
        ?>
        <label></label>
        <img src="captcha.php" alt="" /><br />
        
        <label <?php if(isset($fout['text']['code'])) { echo 'class="fout"'; } ?>>Code:</label>
        <input type="text" id="code" name="code" maxlength="4" size="4" <?php if(isset($fout['input']['code'])) { echo 'class="captcha fout"'; } ?> /><br />
        <?php 
        }
        ?>
        <label for="stuurkopie">Stuur mij een kopie</label><input type="checkbox" id="stuurkopie" name="stuurkopie" value="1" /><br />
        
        <label></label>
        <input type="submit" id="verzenden" name="verzenden" value="verzenden" />
        <input type="submit" id="wis" name="wis" value="Wis velden" />
        </p>
        </form>
    </div>
        
</body>   
</html>
    <?php
    }
}
else 
{
    echo "
    <p>
    U kunt maar eens in de ".$cfg['spam']." minuten een e-mail versturen!<br />
    U wordt nu automatisch doorgestuurd.
    </p>";
    header("refresh:3;url=".$cfg['url']."");
}
?> 